<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Roles
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>

</x-slot>

    <x-nymt.body>
        <div class="flex">
            
	                    
          <div class="flex-1">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search on Role..."/>
          </div>
          <div class="flex-1 pl-2">
            <input wire:model.live="projectsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search on Project..."/>
          </div>
          
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows Per Page" placeholder="Enter Number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $myroles->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
            <x-nymt.table>
                <x-slot name="head">
                    
                        <x-nymt.table.heading sortable wire:click="sortBy('project_id')" :direction="$sortField === 'project_id' ? $sortDirection : null">Project</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('name')" :direction="$sortField === 'name' ? $sortDirection : null">Name</x-nymt.table.heading>
                        <x-nymt.table.heading>First Choice</x-nymt.table.heading>
                        <x-nymt.table.heading>Second Choice</x-nymt.table.heading>
                        <x-nymt.table.heading>Third Choice</x-nymt.table.heading>
                        <x-nymt.table.heading>Comment</x-nymt.table.heading>
                        <x-nymt.table.heading class="w-32">Action</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">

                    @foreach($myroles as $role)
                    
                    <x-nymt.table.row>

                        <x-nymt.table.cell>{{ $role->project->name }}</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$role->id,'object'=>'Role','field'=>'name'], key(rand() * $role->id))</x-nymt.table.cell>
                        
                        <x-nymt.table.cell>to be caluclated</x-nymt.table.cell>
                        <x-nymt.table.cell>coming</x-nymt.table.cell>
                        <x-nymt.table.cell>soon</x-nymt.table.cell>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$role->id,'object'=>'Role','field'=>'comment'], key(rand() * $role->id))</x-nymt.table.cell>

                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="edit({{ $role->id }})" 
                            wire:confirm="Are you sure you want to edit this role date?"
                            ><x-nymt.icon.productdetails /></button>
            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="delete({{ $role->id }})" 
                            wire:confirm="Are you sure you want to delete this role date?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>

                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>