  <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} Venue Date 
        @if ($form->venue_date_id) 
        for {{ $form->venuedate->venue->name }}
        @endif
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    <a class="group" href="/venues/edit/{{ $form->venue_id }}" title="View Venue Grid" alt="View Venue">Back to Venue</a> | 
    <a class="group" href="/venuedates/" title="View Venue Date Grid" alt="View Venue Date Grid">Dates</a>
    </div>
    </x-slot>

    <x-nymt.body>

    <div>
    <form wire:submit="save">

    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Venue Date Details</x-nymt.label>
            <x-nymt.tabs.label>Venue Date Auditions</x-nymt.label>
        </x-slot>

        <x-slot name="body">       
    
            <x-nymt.tabs.section>    
        
                <x-nymt.input.text leadingAddOn="Name" placeholder="Enter Name" wire:model.blur="form.name"></x-nymt.input.text>
                    @error('form.name') <span class="error">{{ $message }}</span> @enderror
                

                <x-nymt.input.text leadingAddOn="Start Date" wire:model.blur="form.start_date" type="date"></x-nymt.input.text>
                
                <x-nymt.input.text leadingAddOn="Start Time" wire:model.blur="form.start_time" type="time"></x-nymt.input.text>
                <x-nymt.input.text leadingAddOn="End Time" wire:model.blur="form.end_time" type="time"></x-nymt.input.text>

                <x-nymt.input.text leadingAddOn="Actor Capacity" placeholder="Enter Actor Capacity" wire:model.blur="form.capacity" infotext="Please enter zero if no actors are allowed (musicians only). An audition with 20 or fewer actors will be only one group, otherwise will be split into three groups."></x-nymt.input.text>
                <x-nymt.input.text leadingAddOn="Musician Capacity" placeholder="Enter Musician Capacity" wire:model.blur="form.musicians" infotext="Please enter zero if no musicians are allowed (actors only)."></x-nymt.input.text>
                <x-nymt.input.text leadingAddOn="Overselling" placeholder="Enter Overselling" wire:model.blur="form.margin" infotext="A positive number here allows you to have more auditions than capacity - a negative number will close the audition before capacity"></x-nymt.input.text>
                
                <x-nymt.input.textarea placeholder="Email Text" wire:model.blur="form.email_text" infotext="This text appears in the booking confirmation email under 'Other information'. Remember that this text goes to musicians as well as actors."></x-nymt.input.textarea>
        
            <div class="text-center">
            <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex class="absolute top-0 right-0 bottom-0 items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </button>
        </div>
            </x-nymt.tabs.section>  
            
            @if ($form->venue_date_id) 
            
            <x-nymt.tabs.section>    
        
        
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Auditionee</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>End Date</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @if (count($form->venuedate->auditions)>0)
                    @foreach($form->venuedate->auditions as $audition)
                        @if ($audition->auditionee)
                    <x-nymt.table.row>
                        <x-nymt.table.cell>{{ $audition->auditionee->firstname}} {{ $audition->auditionee->lastname}}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($audition->venue_date->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($audition->venue_date->end_date)) }}</x-nymt.table.cell>
                        
                        
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                        <button
                            class="group flex"
                            type="button"
                            wire:click="editAudition({{ $audition->auditionee->id }})" 
                            title="Go to Auditionee" alt="Go to Auditionee"
                            ><x-nymt.icon.user-circle /></button>
                        <button
                            class="group flex"
                            type="button"
                            wire:click="deleteAudition({{ $audition->id }})" 
                            wire:confirm="Are you sure you want to delete this Audition?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    </x-nymt.table.row>
                        @else
                        {{ $audition->id }}
                        @endif
                    @endforeach
                    @endif
                </x-slot>

            </x-nymt.table>
        
        
            </x-nymt.tabs.section>  
        
            @endif
        </x-slot>
    </x-nymt.tabs>
    </form>

    </div>
    </x-nymt.body>