   <x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        {{ $this->crud }} Venue
        @if ($form->name)
        - {{ $form->name }}
        @endif
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    <a class="group" href="/venues/" title="View Venue Grid" alt="View Venue Grid">Back to Venue Grid</a>
    </div>
    </x-slot>

    <x-nymt.body>

    <div>

    <form wire:submit="save">
        
        

    <x-nymt.tabs>
        <x-slot name="head">
            <x-nymt.tabs.label>Venue Details</x-nymt.label>
            @if ($form->venue_id) 
            <x-nymt.tabs.label>Auditions</x-nymt.label>
            @endif
        </x-slot>

        <x-slot name="body">       
    
            <x-nymt.tabs.section>    
        
                <x-nymt.input.text leadingAddOn="Name" placeholder="Enter name – shown in booking confirmation email" wire:model.blur="form.name"></x-nymt.input.text>
                    @error('form.name') <span class="error">{{ $message }}</span> @enderror
                
                <x-nymt.input.text leadingAddOn="Address" placeholder="Enter Address – shown in booking confirmation email" wire:model.blur="form.address"></x-nymt.input.text>
                
                    @error('form.address') <span class="error">{{ $message }}</span> @enderror
                <x-nymt.input.text leadingAddOn="Town" placeholder="Enter Town – shown in booking confirmation email" wire:model.blur="form.town"></x-nymt.input.text>
                
                    @error('form.town') <span class="error">{{ $message }}</span> @enderror
                <x-nymt.input.text leadingAddOn="Post Code" placeholder="Enter Post Code – shown in booking confirmation email" wire:model.blur="form.postcode"></x-nymt.input.text>
                
                    @error('form.postcode') <span class="error">{{ $message }}</span> @enderror
                
                <x-nymt.input.text leadingAddOn="Email" placeholder="Leave blank – this field not currently used" wire:model.blur="form.email"></x-nymt.input.text>

                    @error('form.email') <span class="error">{{ $message }}</span> @enderror
     
                <x-nymt.input.text leadingAddOn="Tel" placeholder="Leave blank – this field not currently used" wire:model.blur="form.tel"></x-nymt.input.text>
                
                <x-nymt.input.text leadingAddOn="Website" placeholder="Enter &apos;how to find us&apos; address – shown in booking confirmation email" wire:model.blur="form.website"></x-nymt.input.text>
        
     
                <x-nymt.input.text leadingAddOn="Capacity" placeholder="Leave blank – this field not currently used" wire:model.blur="form.capacity"></x-nymt.input.text>
        
                <x-nymt.input.text leadingAddOn="Photo" placeholder="Leave blank – this field not currently used" wire:model="form.venue_photo_path" disabled></x-nymt.input.text>
                
                <div class="flex rounded-md shadow-sm px-3 py-2 rounded-lg">
                    @if ($form->venue_photo_path) 
                    <img src="/media/venues/{{ $form->venue_photo_path }}" width="200">
                    @endif
                    <input type="file" wire:model.live="form.venue_photo">
                    @if ($form->venue_photo) 
                    <div class="text-center"><img src="{{ $form->venue_photo->temporaryUrl() }}" width="200"></div>
                    @endif
 
                    @error('form.venue_photo') <span class="error">{{ $message }}</span> @enderror
                </div>
        
        <div class="text-center">
            <button type="submit" class="relative max-w-sm w-full bg-blue-500 py-3 px-8 rounded-lg text-white font-medium disabled:cursor-not-allowed disabled:opacity-75">
                Save

                <div wire:loading.flex class="absolute top-0 right-0 bottom-0 items-center pr-4">
                    <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                </div>
            </button>
        </div>
         </x-nymt.tabs.section>  
        
            @if ($form->venue_id) 
            <x-nymt.tabs.section> 
            
            
            <div class="flex">
                <div class="flex-none">
                    <x-nymt.button.primarylink href="{{ url('/venuedates/create/'.$form->venue_id) }}">Create Auditions</x-nymt.button.primarylink>
                </div>
            </div>
                
            <x-nymt.table>

                <x-slot name="head">
                    
                        <x-nymt.table.heading>Name</x-nymt.table.heading>
                        <x-nymt.table.heading>Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading>End Date</x-nymt.table.heading>
                        <x-nymt.table.heading>Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading></x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">
                    @foreach($form->venue->dates as $venuedate)
                    <x-nymt.table.row>
                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venuedate->id,'object'=>'VenueDate','field'=>'name'], key(rand() * $venuedate->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('Y-m-d' , strtotime($venuedate->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('Y-m-d' , strtotime($venuedate->end_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ $venuedate->capacity }}</x-nymt.table.cell>
                        
                        <x-nymt.table.cell>
                        <x-nymt.icon.group>
                            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="editDate({{ $venuedate->id }})" 
                            wire:confirm="Are you sure you want to edit this audition?"
                            ><x-nymt.icon.productdetails /></button>
            
                        <button
                            class="group flex"
                            type="button"
                            wire:click="deleteDate({{ $venuedate->id }})" 
                            wire:confirm="Are you sure you want to delete this audition?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin /></button>
                        </x-nymt.icon.group>
                        </x-nymt.table.cell>
                    
                    </x-nymt.table.row>
                    @endforeach
                </x-slot>

            </x-nymt.table>
            
            </x-nymt.tabs.section>  
            @endif
        </x-slot>
    </x-nymt.tabs>
    </form>

</div>
    </x-nymt.body>