<x-slot name="header">
    <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
    <div>
    <x-nymt.html.title>
        Manage Auditions
    </x-nymt.html.title>
    </div>
    <div class="md:text-right">
    
    </div>
</div>

</x-slot>

    <x-nymt.body>
        <div class="flex">
          <div class="flex-none">
            <!--<x-nymt.button.primarylink href="{{ url('/venuedates/create') }}">Create Venue Date</x-nymt.button.primarylink>-->
            
          </div>
            
	                    
          <div class="flex-1">
            <input wire:model.live="inputsearch"  class="shadow appearance-none border rounded w-full py-2 px-3 my-3 ml-2 text-gray-700 leading-tight focus:outline-none focus:shadow-outline" type="text" placeholder="Search for name or town..."/>
          </div>
          
          <div class="flex-0">
              <div class="m-1 text-right">
                  <x-nymt.input.text leadingAddOn="Rows per page" placeholder="Enter number of rows per page" wire:model.live.debounce.500ms="perPage" />
              </div>
          </div>
            
          </div>
          <div class="flex-1">
          <div class="flex-none">
              <div class="m-1 text-right">
            {{ $myvenuedates->onEachSide(0)->links() }}
              </div>
          </div>
          </div>
            <x-nymt.table>
                <x-slot name="head">
                    
                        <x-nymt.table.heading sortable wire:click="sortBy('name')" :direction="$sortField === 'name' ? $sortDirection : null">Name</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('start_date')" :direction="$sortField === 'start_date' ? $sortDirection : null">Start Date</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('start_time')" :direction="$sortField === 'start_time' ? $sortDirection : null">Start Time</x-nymt.table.heading>
                        <x-nymt.table.heading sortable wire:click="sortBy('end_time')" :direction="$sortField === 'end_time' ? $sortDirection : null">End Time</x-nymt.table.heading>                   
                        <x-nymt.table.heading sortable wire:click="sortBy('venue_id')" :direction="$sortField === 'venue_id' ? $sortDirection : null">Venue</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center bg-blue-300">Actor Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center bg-blue-300">Overselling</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center bg-blue-300">Actor Status</x-nymt.table.heading>
                        <x-nymt.table.heading class="border text-center bg-blue-300">Actors</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center bg-blue-100">Musician Capacity</x-nymt.table.heading>
                        <x-nymt.table.heading class="text-center bg-blue-100">Musician Status</x-nymt.table.heading>
                        <x-nymt.table.heading class="border text-center bg-blue-100">Musicians</x-nymt.table.heading>
                        <x-nymt.table.heading colspan="2" class="text-center">Action</x-nymt.table.heading>

                </x-slot>

                <x-slot name="body">

                    @foreach($myvenuedates as $venuedate)
                    
                    <x-nymt.table.row class="{{ $loop->index % 2 === 0 ? 'bg-gray-50' : '' }}">

                        <x-nymt.table.cell>@livewire('component.edit-field',['id'=>$venuedate->id,'object'=>'VenueDate','field'=>'name'], key(rand() * $venuedate->id))</x-nymt.table.cell>
                        <x-nymt.table.cell>{{ date('d-M-y' , strtotime($venuedate->start_date)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('H:i', strtotime($venuedate->start_time)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>{{  date('H:i', strtotime($venuedate->end_time)) }}</x-nymt.table.cell>
                        <x-nymt.table.cell>@if ($venuedate->venue)
                                {{ $venuedate->venue->name }}
                                @endif
                                </x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ $venuedate->capacity }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ $venuedate->margin }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center {{ $venuedate->availabilityClass() }}">{{ $venuedate->availabilityLabel() }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center bg-blue-300">{{ count($venuedate->actorauditions()) }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center">{{ $venuedate->musicians }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center {{ $venuedate->musicianavailabilityClass() }}">{{ $venuedate->musicianavailabilityLabel() }}</x-nymt.table.cell>
                        <x-nymt.table.cell class="text-center bg-blue-100">{{ count($venuedate->musicianauditions()) }}</x-nymt.table.cell>
                            
                        <x-nymt.table.cell class="text-center">
                        <button
                            class="group text-center"
                            type="button"
                            wire:click="auditionlist({{ $venuedate->id }})" 
                            ><x-nymt.icon.eye /></button> 
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                           <a href="/export-csv/auditionees/{{ $venuedate->id }}" target="_blank" class="text-center"><x-nymt.icon.download /></a>
                        @endif
                        </x-nymt.table.cell>
                        @if (Auth::user()->hasTeamPermission(Auth::user()->currentTeam, 'create'))
                        <x-nymt.table.cell class="text-center">
                            <button
                            type="button"
                            wire:click="edit({{ $venuedate->id }})" 
                            ><x-nymt.icon.edit />
                            </button>
                            <button
                            type="button"
                            wire:click="delete({{ $venuedate->id }})" 
                            wire:confirm="Are you sure you want to delete this venue date?"
                            title="Delete" alt="Delete"
                            ><x-nymt.icon.bin />
                            </button>
                        </x-nymt.table.cell>
                        @endif
                    </x-nymt.table.row>

                    @endforeach

                </x-slot>

            </x-nymt.table>
    </x-nymt.body>